--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--
rollout DYNmrPhysicalSky ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCmapSize  = [166,40]
  local LOCpreviewBitmap
  local LOCrenderMap

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNdisplaySkyControls =
  (
    for i in DYNmrPhysicalSky.controls do i.enabled = false
    DYNmrPhysicalSky.BUDYNreset.enabled = true
  )

  fn DYNFUNdisplaySkyParams =
  (
    if classof environmentMap == mr_Physical_sky then
    (
      for i in DYNmrPhysicalSky.controls do i.enabled = true
      DYNmrPhysicalSky.CBDYNonOff.checked      = useEnvironmentMap
      DYNmrPhysicalSky.CODYNground.color       = environmentMap.GroundColor
      DYNmrPhysicalSky.CODYNnight.color        = environmentMap.NightColor
      DYNmrPhysicalSky.SPDYNsunDiskInt.value   = environmentMap.SunIntensity
      DYNmrPhysicalSky.SPDYNsunScale.value     = environmentMap.sunScale
      DYNmrPhysicalSky.SPDYNsunGlowInt.value   = environmentMap.SunGlow
      DYNmrPhysicalSky.SPDYNmultiplier.value   = environmentMap.multiplier
      DYNmrPhysicalSky.SPDYNhaze.value         = environmentMap.Haze
      DYNmrPhysicalSky.SPDYNhorHeight.value    = environmentMap.HorizonHeight
      DYNmrPhysicalSky.SPDYNblur.value         = environmentMap.HorizonBlur
      DYNmrPhysicalSky.SPDYNredBlue.value      = environmentMap.Redness
      DYNmrPhysicalSky.SPDYNsaturation.value   = environmentMap.Saturation

      DYNmrPhysicalSky.SPDYNaerial.value       = environmentMap.AerialPerspective

      DYNmrPhysicalSky.CBDYNinherit.checked    = environmentMap.InheritFromSky
      DYNmrPhysicalSky.SPDYNmultiplier.enabled = not environmentMap.InheritFromSky
      DYNmrPhysicalSky.SPDYNhaze.enabled       = not environmentMap.InheritFromSky
      DYNmrPhysicalSky.SPDYNhorHeight.enabled  = not environmentMap.InheritFromSky
      DYNmrPhysicalSky.SPDYNblur.enabled       = not environmentMap.InheritFromSky
      DYNmrPhysicalSky.SPDYNredBlue.enabled    = not environmentMap.InheritFromSky
      DYNmrPhysicalSky.SPDYNsaturation.enabled = not environmentMap.InheritFromSky
      DYNmrPhysicalSky.LBDYNmultiplier.enabled = not environmentMap.InheritFromSky
      DYNmrPhysicalSky.LBDYNhaze.enabled       = not environmentMap.InheritFromSky
      DYNmrPhysicalSky.LBDYNhorHeight.enabled  = not environmentMap.InheritFromSky
      DYNmrPhysicalSky.LBDYNblur.enabled       = not environmentMap.InheritFromSky
      DYNmrPhysicalSky.LBDYNredBlue.enabled    = not environmentMap.InheritFromSky
      DYNmrPhysicalSky.LBDYNsaturation.enabled = not environmentMap.InheritFromSky
      DYNmrPhysicalSky.CODYNground.enabled     = not environmentMap.InheritFromSky
      DYNmrPhysicalSky.CODYNnight.enabled      = not environmentMap.InheritFromSky
      DYNmrPhysicalSky.LBDYNground.enabled     = not environmentMap.InheritFromSky
      DYNmrPhysicalSky.LBDYNnight.enabled      = not environmentMap.InheritFromSky
    )
    else
    (
      DYNFUNdisplaySkyControls()
    )
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  checkbox CBDYNonoff pos:[9,9]

  groupbox GBDYNgroup01 width:(DYNiniExplorerWidth - 21) height:88 pos:[4,30]

  label LBDYNsunDiskInt   pos:[13,52] width:95
  label LBDYNsunGlowInt   pos:[13,73] width:95
  label LBDYNsunScale     pos:[13,94] width:95

  spinner SPDYNsunDiskInt pos:[(DYNiniExplorerWidth - 96),49] fieldwidth:60 range:[0,25,0] scale:0.1
  spinner SPDYNsunGlowInt pos:[(DYNiniExplorerWidth - 96),70] fieldwidth:60 range:[0,25,0] scale:0.1
  spinner SPDYNsunScale   pos:[(DYNiniExplorerWidth - 96),91] fieldwidth:60 range:[0,25,0] scale:0.1

  groupbox GBDYNgroup02 pos:[4,124] width:(DYNiniExplorerWidth - 21) height:270
  checkbox CBDYNinherit   pos:[13,144] width:158

  label LBDYNmultiplier   pos:[13,171] width:95
  label LBDYNhaze         pos:[13,192] width:95
  label LBDYNhorHeight    pos:[13,213] width:95
  label LBDYNblur         pos:[13,234] width:95

  spinner SPDYNmultiplier pos:[(DYNiniExplorerWidth - 96),168] fieldwidth:60 range:[0.0,100.0,0.0] scale:0.1
  spinner SPDYNhaze       pos:[(DYNiniExplorerWidth - 96),189] fieldwidth:60 range:[0.0,15.0,0.0]  scale:0.1
  spinner SPDYNhorHeight  pos:[(DYNiniExplorerWidth - 96),210] fieldwidth:60 range:[-10,10,0]    scale:0.1
  spinner SPDYNblur       pos:[(DYNiniExplorerWidth - 96),231] fieldwidth:60 range:[0,10.0,0]    scale:0.1

  label LBDYNground       pos:[13,254] width:155
  colorpicker CODYNground "" fieldwidth:(DYNiniExplorerWidth - 39) height:20 pos:[10,270]

  label LBDYNnight         pos:[13,298] width:155
  colorpicker CODYNnight "" fieldwidth:(DYNiniExplorerWidth - 39) height:20 pos:[10,314]

  label LBDYNredBlue      pos:[13,353] width:95
  label LBDYNsaturation   pos:[13,374] width:95
  spinner SPDYNredBlue    pos:[(DYNiniExplorerWidth - 96),350] fieldwidth:60 range:[-1,1,0]    scale:0.1
  spinner SPDYNsaturation pos:[(DYNiniExplorerWidth - 96),371] fieldwidth:60 range:[0,2,0]    scale:0.05

  groupbox GBDYNgroup03 width:(DYNiniExplorerWidth - 21) height:46 pos:[4,403]

  label LBDYNaerial      pos:[13,425] width:95
  spinner SPDYNaerial    pos:[(DYNiniExplorerWidth - 96),422] fieldwidth:60 range:[0,100000002004087730000.0,0]    scale:0.001

  button BUDYNreset width:(DYNiniExplorerWidth - 21) algin:#center pos:[4,458]

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNmrPhysicalSky open do
  (
    DYNmrPhysicalSky.title = DYNuiRolloutNames[28]

    GBDYNgroup01.text      = DYNuiResourcesGroups[79]
    GBDYNgroup02.text      = DYNuiResourcesGroups[80]
    GBDYNgroup03.text      = DYNuiResourcesGroups[81]
    CBDYNinherit.text      = DYNuiResourcesGroups[82]

    LBDYNsunDiskInt.text   = DYNuiResourcesLabels[252]
    LBDYNsunGlowInt.text   = DYNuiResourcesLabels[253]
    LBDYNsunScale.text     = DYNuiResourcesLabels[254]
    LBDYNhaze.text         = DYNuiResourcesLabels[255]
    LBDYNhorHeight.text    = DYNuiResourcesLabels[256]
    LBDYNblur.text         = DYNuiResourcesLabels[257]
    LBDYNredBlue.text      = DYNuiResourcesLabels[258]
    LBDYNsaturation.text   = DYNuiResourcesLabels[259]
    LBDYNaerial.text       = DYNuiResourcesLabels[260]
    LBDYNground.text       = DYNuiResourcesLabels[261]
    LBDYNnight.text        = DYNuiResourcesLabels[262]
    LBDYNmultiplier.text   = DYNuiResourcesLabels[131]

    CBDYNonOff.text        = DYNuiResourcesLabels[22]
    BUDYNreset.text        = DYNuiResourcesButtons[13]

    DYNFUNdisplaySkyParams()
  )

  on DYNmrPhysicalSky close do
  (
  )

  on CODYNground     changed arg do (try (environmentMap.GroundColor       = arg) catch (DYNFUNdisplaySkyControls()))
  on CODYNnight      changed arg do (try (environmentMap.NightColor        = arg) catch (DYNFUNdisplaySkyControls()))
  on SPDYNsunDiskInt changed arg do (try (environmentMap.SunIntensity      = arg) catch (DYNFUNdisplaySkyControls()))
  on SPDYNsunScale   changed arg do (try (environmentMap.sunScale          = arg) catch (DYNFUNdisplaySkyControls()))
  on SPDYNsunGlowInt changed arg do (try (environmentMap.SunGlow           = arg) catch (DYNFUNdisplaySkyControls()))
  on SPDYNmultiplier changed arg do (try (environmentMap.multiplier        = arg) catch (DYNFUNdisplaySkyControls()))
  on SPDYNhaze       changed arg do (try (environmentMap.Haze              = arg) catch (DYNFUNdisplaySkyControls()))
  on SPDYNhorHeight  changed arg do (try (environmentMap.HorizonHeight     = arg) catch (DYNFUNdisplaySkyControls()))
  on SPDYNblur       changed arg do (try (environmentMap.HorizonBlur       = arg) catch (DYNFUNdisplaySkyControls()))
  on SPDYNredBlue    changed arg do (try (environmentMap.Redness           = arg) catch (DYNFUNdisplaySkyControls()))
  on SPDYNsaturation changed arg do (try (environmentMap.Saturation        = arg) catch (DYNFUNdisplaySkyControls()))
  on SPDYNaerial     changed arg do (try (environmentMap.AerialPerspective = arg) catch (DYNFUNdisplaySkyControls()))

  on CBDYNinherit    changed arg do
  (
    local LOCsuccessSwitch = false
    try (environmentMap.InheritFromSky    = arg; LOCsuccessSwitch = true) catch (DYNFUNdisplaySkyControls())
    if LOCsuccessSwitch then
    (
      SPDYNmultiplier.enabled = not environmentMap.InheritFromSky
      SPDYNhaze.enabled       = not environmentMap.InheritFromSky
      SPDYNhorHeight.enabled  = not environmentMap.InheritFromSky
      SPDYNblur.enabled       = not environmentMap.InheritFromSky
      SPDYNredBlue.enabled    = not environmentMap.InheritFromSky
      SPDYNsaturation.enabled = not environmentMap.InheritFromSky
      LBDYNmultiplier.enabled = not environmentMap.InheritFromSky
      LBDYNhaze.enabled       = not environmentMap.InheritFromSky
      LBDYNhorHeight.enabled  = not environmentMap.InheritFromSky
      LBDYNblur.enabled       = not environmentMap.InheritFromSky
      LBDYNredBlue.enabled    = not environmentMap.InheritFromSky
      LBDYNsaturation.enabled = not environmentMap.InheritFromSky
      CODYNground.enabled     = not environmentMap.InheritFromSky
      CODYNnight.enabled      = not environmentMap.InheritFromSky
      LBDYNground.enabled     = not environmentMap.InheritFromSky
      LBDYNnight.enabled      = not environmentMap.InheritFromSky
    )
  )

  on CBDYNonOff       changed val do
  (
    useEnvironmentMap = val
    if val == false then DYNamite.dnSkyNode.forecolor = DYNFUNdnColor (DYNINIgreyedOutColor) else DYNamite.dnSkyNode.forecolor = DYNFUNdnColor (((colorMan.getColor #text) as color) * 255)
  )

  on BUDYNreset pressed do
  (
    DYNskyDome.DYNFUNresetSky true
  )
)
